/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.preferences;

import com.aptana.editor.php.internal.builder.IPHPLibrary;
import com.aptana.editor.php.internal.builder.LibraryManager;
import com.aptana.editor.php.internal.builder.PHPLibrary;
import com.aptana.editor.php.internal.builder.UserLibrary;
import com.aptana.editor.php.internal.ui.preferences.LibraryLabelProvider;
import com.aptana.editor.php.internal.ui.preferences.Messages;
import com.aptana.editor.php.internal.ui.preferences.PHPLibraryDialog;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PHPLibrariesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer newCheckList;

    protected Control createContents(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(body, 64);
        label.setText(Messages.PHPLibrariesPreferencePage_librariesTitle);
        final HashMap<URL, Image> images = new HashMap<URL, Image>();
        Composite tableAndButton = new Composite(body, 0);
        tableAndButton.setLayout((Layout)new GridLayout(2, false));
        this.newCheckList = CheckboxTableViewer.newCheckList((Composite)tableAndButton, (int)2048);
        this.newCheckList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.newCheckList.setInput((Object)LibraryManager.getInstance().getAllLibraries());
        Composite buttons = new Composite(tableAndButton, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        this.newCheckList.setComparator(new ViewerComparator());
        this.newCheckList.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider(images));
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 400;
        this.newCheckList.getControl().setLayoutData((Object)layoutData);
        body.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (Image m : images.values()) {
                    m.dispose();
                }
            }
        });
        layoutData = new GridData();
        layoutData.heightHint = 400;
        body.setLayoutData((Object)layoutData);
        IPHPLibrary[] iPHPLibraryArray = LibraryManager.getInstance().getAllLibraries();
        int n = iPHPLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            this.newCheckList.setChecked((Object)l, l.isTurnedOn());
            ++n2;
        }
        buttons.setLayoutData((Object)new GridData(1040));
        Button add = new Button(buttons, 8);
        add.setText(Messages.PHPLibrariesPreferencePage_newUserLibrary);
        add.setLayoutData((Object)new GridData(768));
        add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPLibraryDialog libraryDialog = new PHPLibraryDialog(Display.getCurrent().getActiveShell(), null, PHPLibrariesPreferencePage.this.getContent());
                if (libraryDialog.open() == 0) {
                    UserLibrary result = libraryDialog.getResult();
                    PHPLibrariesPreferencePage.this.newCheckList.add((Object)result);
                    PHPLibrariesPreferencePage.this.newCheckList.setChecked((Object)result, true);
                }
            }
        });
        final Button edit = new Button(buttons, 8);
        edit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)PHPLibrariesPreferencePage.this.newCheckList.getSelection();
                UserLibrary firstElement = (UserLibrary)ss.getFirstElement();
                PHPLibraryDialog libraryDialog = new PHPLibraryDialog(Display.getCurrent().getActiveShell(), firstElement, PHPLibrariesPreferencePage.this.getContent());
                if (libraryDialog.open() == 0) {
                    PHPLibrariesPreferencePage.this.newCheckList.remove((Object)firstElement);
                    PHPLibrariesPreferencePage.this.newCheckList.add((Object)libraryDialog.getResult());
                }
            }
        });
        edit.setText(Messages.PHPLibrariesPreferencePage_editLibrary);
        edit.setLayoutData((Object)new GridData(768));
        final Button remove = new Button(buttons, 8);
        remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection ss = (IStructuredSelection)PHPLibrariesPreferencePage.this.newCheckList.getSelection();
                Object[] objectArray = ss.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    PHPLibrariesPreferencePage.this.newCheckList.remove(o);
                    ++n2;
                }
            }
        });
        remove.setText(Messages.PHPLibrariesPreferencePage_removeLibrary);
        tableAndButton.setLayoutData((Object)new GridData(1808));
        remove.setLayoutData((Object)new GridData(768));
        this.newCheckList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                if (ss.isEmpty() || ss.getFirstElement() instanceof PHPLibrary) {
                    edit.setEnabled(false);
                    remove.setEnabled(false);
                    return;
                }
                edit.setEnabled(true);
                remove.setEnabled(true);
            }
        });
        Button selectAll = new Button(buttons, 8);
        selectAll.setText(Messages.LibrariesPage_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectAction(true));
        Button deselectAll = new Button(buttons, 8);
        deselectAll.setText(Messages.LibrariesPage_deselectAll);
        selectAll.setLayoutData((Object)new GridData(768));
        deselectAll.setLayoutData((Object)new GridData(768));
        deselectAll.addSelectionListener((SelectionListener)new SelectAction(false));
        edit.setEnabled(false);
        remove.setEnabled(false);
        return body;
    }

    IPHPLibrary[] getContent() {
        int count = this.newCheckList.getTable().getItemCount();
        ArrayList<IPHPLibrary> ul = new ArrayList<IPHPLibrary>();
        int a = 0;
        while (a < count) {
            Object elementAt = this.newCheckList.getElementAt(a);
            ul.add((IPHPLibrary)elementAt);
            ++a;
        }
        return ul.toArray(new IPHPLibrary[ul.size()]);
    }

    protected void performDefaults() {
        this.newCheckList.setAllChecked(true);
    }

    public boolean performOk() {
        HashSet<IPHPLibrary> turnedOff = new HashSet<IPHPLibrary>();
        IPHPLibrary[] iPHPLibraryArray = LibraryManager.getInstance().getAllLibraries();
        int n = iPHPLibraryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPHPLibrary l = iPHPLibraryArray[n2];
            boolean checked = this.newCheckList.getChecked((Object)l);
            if (!checked) {
                turnedOff.add(l);
            }
            ++n2;
        }
        int count = this.newCheckList.getTable().getItemCount();
        ArrayList<UserLibrary> ul = new ArrayList<UserLibrary>();
        int a = 0;
        while (a < count) {
            Object elementAt = this.newCheckList.getElementAt(a);
            if (elementAt instanceof UserLibrary) {
                ul.add((UserLibrary)elementAt);
            }
            ++a;
        }
        LibraryManager.getInstance().setUserLibraries(ul.toArray(new UserLibrary[ul.size()]));
        LibraryManager.getInstance().setTurnedOff(turnedOff);
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    private final class SelectAction
    implements SelectionListener {
        boolean select;

        private SelectAction(boolean doSelect) {
            this.select = doSelect;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            PHPLibrariesPreferencePage.this.newCheckList.setAllChecked(this.select);
        }
    }
}

